<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once('load_settings.php');

// Check if the request is to add a promoter
if (isset($_POST['addpromoter'])) {
    // Sanitize input
    $name       = trim($_POST['promoter_name']);
    $username   = trim($_POST['promoter_username']);
    $password   = $_POST['promoter_password'];
    $conf_pass  = $_POST['promoter_confirmpassword'];
    $email      = trim($_POST['promoter_email']);
    $phone      = trim($_POST['promoter_phone']);
    $country    = intval($_POST['promoter_country']);
    $city       = intval($_POST['promoter_city']);
    $area       = intval($_POST['promoter_area']);
    $address    = trim($_POST['promoter_address']);
    $status     = intval($_POST['promoter_status']);
    $date       = date('Y-m-d H:i:s');

    // Check password match
    if ($password !== $conf_pass) {
        echo '<div class="alert alert-danger">Passwords do not match.</div>';
        exit;
    }

    // Check if username/email/phone already exists
    $checkSql = "SELECT promoter_id FROM dss_promoter WHERE promoter_username = ? OR promoter_email = ? OR promoter_phone = ?";
    $stmt = $con->prepare($checkSql);
    $stmt->bind_param("sss", $username, $email, $phone);
    $stmt->execute();
    $stmt->store_result();
    if ($stmt->num_rows > 0) {
        echo '<div class="alert alert-danger">Username, Email or Phone already exists.</div>';
        exit;
    }
    $stmt->close();

    // Generate promoter_code (you can improve logic as needed)
    $promoter_code = 'PRM-' . strtoupper(substr(md5(uniqid()), 0, 6));

    // Encrypt password (use stronger methods in production like password_hash)
    $hashed_password = password_hash($password, PASSWORD_DEFAULT);

    // Insert promoter
    $insertSql = "INSERT INTO dss_promoter (
        promoter_code, promoter_name, promoter_username, promoter_password,
        promoter_email, promoter_phone, promoter_country, promoter_city, 
        promoter_area, promoter_address, promoter_status, promoter_date
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

    $stmt = $con->prepare($insertSql);
    if ($stmt === false) {
        echo '<div class="alert alert-danger">Database error: ' . $con->error . '</div>';
        exit;
    }

    $stmt->bind_param("sssssssiiiss", 
        $promoter_code, $name, $username, $hashed_password,
        $email, $phone, $country, $city, $area, $address, $status, $date
    );

    if ($stmt->execute()) {
        echo '<div class="alert alert-success">Promoter added successfully!</div>';
    } else {
        echo '<div class="alert alert-danger">Error adding promoter: ' . $stmt->error . '</div>';
    }

    $stmt->close();
    $con->close();
}
?>


